IF EXISTS (SELECT * FROM SYS.OBJECTS 
			WHERE  
				OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_EST_PARAM_COMPRAS_GRUPO_CURVA]')
				AND TYPE IN(N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_EST_PARAM_COMPRAS_GRUPO_CURVA];
GO

CREATE PROCEDURE [DBO].[P_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_EST_PARAM_COMPRAS_GRUPO_CURVA]   (@CD_EMP INT, @CD_FILIAL INT, @CD_PROD INT=0)
AS              
 SET NOCOUNT ON;

 DECLARE @CD_CTR INT;


	CREATE TABLE #RS_TAB_PARAMETROS(CD_EMP                       INT
								, CD_CTR                       INT
								, CD_PROD                      INT
								, CD_GRUPO_CURVA               INT
								, CD_SIGLA                     INT
								, DS_SIGLA                     VARCHAR(2)
								, ORDEM_SIGLA                  INT
								, ESEG                         INT
								, EMAX                         INT
								, P1                           MONEY
								, P2                           MONEY
								, P1_SAZ                       MONEY
								, P2_SAZ                       MONEY
								, FREVISAOMEDIAF               INT
								, PERC_PARETO_ACUMULADO        MONEY
								, TP_NIVEL                     INT
								, FLAG_NAO_REVISAR_PARETO_AUTO INT
								, VLR_PARAMETRO_ATUAL          MONEY
								, FREVISAOCURVA                INT
							);
	IF OBJECT_ID('tempdb..#RS_RET', 'U') IS NOT NULL
			DROP TABLE #RS_RET;


	CREATE TABLE #RS_RET(CD_EMP							  INT NOT NULL
						   , CD_CTR                       INT  
						   , CD_PROD                      INT NOT NULL
						   , CD_GRUPO_CURVA               INT
						   , CD_SIGLA                     INT NOT NULL
						   , DS_SIGLA                     VARCHAR(2)
						   , ORDEM_SIGLA                  INT
						   , ESEG                         INT
						   , EMAX                         INT
						   , P1                           MONEY
						   , P2                           MONEY
						   , P1_SAZ                       MONEY
						   , P2_SAZ                       MONEY
						   , FREVISAOMEDIAF               INT
						   , PERC_PARETO_ACUMULADO        MONEY
						   , TP_NIVEL                     INT
						   , FLAG_NAO_REVISAR_PARETO_AUTO INT
						   , VLR_PARAMETRO_ATUAL          MONEY
						   , DS_GRUPO_PARAMETRO           VARCHAR(200)
						   , FREVISAOCURVA                INT);

	/************************************************************************************************************/

	CREATE TABLE #TBL_NIVEL(TP_NIVEL INT, DS_NIVEL VARCHAR(20));
	CREATE TABLE #TBL_NIVEL_MENOR(CD_EMP     INT, CD_PROD    INT, NIVELMENOR INT);

	INSERT INTO #TBL_NIVEL
		SELECT 1 , 'PRODUTO'
		   UNION SELECT 2, 'FAMILIA'
		   UNION SELECT 3, 'MARCA'
		   UNION SELECT 4, 'FABRICANTE'
		   UNION SELECT 5, 'CATEGORIA'
		   UNION SELECT 6, 'LINHA';
	
	/************************************************************************************************************/

	IF @CD_PROD > 0
	BEGIN
		INSERT INTO #RS_TAB_PARAMETROS
		SELECT
			   A.CD_EMP
			 , A.CD_CTR
			 , A.CD_PROD
			 , A.CD_GRUPO_CURVA
			 , A.CD_SIGLA
			 , A.DS_SIGLA
			 , A.ORDEM_SIGLA
			 , A.ESEG
			 , A.EMAX
			 , A.P1
			 , A.P2
			 , A.P1_SAZ
			 , A.P2_SAZ
			 , A.FREVISAOMEDIAF
			 , A.PERC_PARETO_ACUMULADO
			 , A.TP_NIVEL
			 , A.FLAG_NAO_REVISAR_PARETO_AUTO
			 , A.VLR_PARAMETRO_ATUAL
			 , A.FREVISAOCURVA
		FROM 
			 EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL F
			 JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P ON 
			 F.CD_EMP = P.CD_EMP AND
			 F.CD_FILIAL = P.CD_FILIAL 
			 CROSS APPLY UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES(P.CD_EMP, F.CD_CTR, P.CD_PROD) A
		WHERE P.CD_EMP = @CD_EMP
			  AND P.CD_FILIAL = @CD_FILIAL
			  AND P.CD_PROD =@CD_PROD;
	END
	ELSE
	BEGIN
	
		SET @CD_CTR = ISNULL((SELECT CD_CTR 
						FROM EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL
							WHERE CD_EMP =@CD_EMP  
									AND CD_FILIAL = @CD_FILIAL),0);
		IF @CD_CTR =0 
		BEGIN
			PRINT 'GRUPO DE PARAMETROS NAO DEFINIDO PARA A FILIAL '
			RETURN
		END

		/****************************************************************************************************************/
		/*
		   DROP TABLE #RS_PROD_ARV_MERC   
		   DROP TABLE #RS_DADOS_TBL_PARAM   
		   DROP TABLE #TMPRESULTGERAL
		   DROP TABLE #TMPRESULT          
		 */
		/****************************************************************************************************************/
		CREATE TABLE #TMPRESULTGERAL  ( CD_EMP	INT
									,CD_CTR	INT
									,CD_FILIAL	INT
									,CD_PROD	INT
									,CD_GRUPO_CURVA	INT
									,CD_SIGLA	INT
									,DS_SIGLA	VARCHAR (2)
									,ORDEM_SIGLA	INT
									,ESEG	INT
									,EMAX	INT
									,P1	MONEY
									,P2	MONEY
									,P1_SAZ	MONEY
									,P2_SAZ	MONEY
									,FREVISAOMEDIAF	INT
									,PERC_PARETO_ACUMULADO	MONEY
									,TP_NIVEL	INT
									,FLAG_NAO_REVISAR_PARETO_AUTO	INT
									,VLR_PARAMETRO	MONEY
									,FREVISAOCURVA	INT
									)
							
		CREATE TABLE #TMPRESULT  ( CD_EMP	INT
									,CD_CTR	INT
									,CD_FILIAL	INT
									,CD_PROD	INT
									,CD_GRUPO_CURVA	INT
									,CD_SIGLA	INT
									,DS_SIGLA	VARCHAR (2)
									,ORDEM_SIGLA	INT
									,ESEG	INT
									,EMAX	INT
									,P1	MONEY
									,P2	MONEY
									,P1_SAZ	MONEY
									,P2_SAZ	MONEY
									,FREVISAOMEDIAF	INT
									,PERC_PARETO_ACUMULADO	MONEY
									,TP_NIVEL	INT
									,FLAG_NAO_REVISAR_PARETO_AUTO	INT
									,VLR_PARAMETRO	MONEY
									,FREVISAOCURVA	INT
									) 
							          
		CREATE TABLE  #RS_DADOS_TBL_PARAM  (CD_EMP INT,
											  CD_CTR INT,
											  CD_PROD INT,
											  CD_GRUPO_CURVA INT,
											  CD_SIGLA INT,
											  ESEG INT,
											  EMAX INT,
											  P1 MONEY,
											  P2 MONEY,
											  P1_SAZ MONEY,
											  P2_SAZ MONEY,
											  FREVISAOMEDIAF INT,
											  PERC_PARETO_ACUMULADO MONEY,
											  TP_NIVEL	INT,
											  FLAG_NAO_REVISAR_PARETO_AUTO INT,
											  FREVISAOCURVA INT)  

		 -------------------------------------------------------------------------------------------------------------------------------      
		 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
		 -------------------------------------------------------------------------------------------------------------------------------      
		 CREATE TABLE #RS_PROD_ARV_MERC  (  CD_EMP     INT,      
				  CD_PROD   INT,      
				  CD_ARV_MERC_CATEG INT,      
				  CD_ARV_MERC_SEG INT,      
				  CD_ARV_MERC_PAPEL INT,      
				  CD_ARV_MERC_MIX INT,      
				  CD_ARV_MERC_CONSUMO INT,      
				  CD_ARV_MERC_LINHA INT,      
				  CD_ARV_MERC_MTZ_BCG INT,      
				  CD_MC   INT,      
				  CD_ARV_MERC_FAMILIA INT,              
				  CD_APRES   INT,          
				  CD_ARV_MERC_EQUI INT,      
				  CD_GRP_EXPO  INT,      
				  CD_FABRIC   INT)      
            
		 -------------------------------------------------------------------------------------------------------------------------------      
		 --BUSCANDO ARVORE MERC. DO PRODUTO      
		 -------------------------------------------------------------------------------------------------------------------------------       
			INSERT INTO #RS_PROD_ARV_MERC      
			SELECT       
				ARV.CD_EMP     ,      
				ARV.CD_PROD     ,      
				ARV.CD_ARV_MERC_CATEG  ,      
				ARV.CD_ARV_MERC_SEG   ,      
				ARV.CD_ARV_MERC_PAPEL  ,      
				ARV.CD_ARV_MERC_MIX   ,      
				ARV.CD_ARV_MERC_CONSUMO  ,      
				ARV.CD_ARV_MERC_LINHA  ,      
				ARV.CD_ARV_MERC_MTZ_BCG  ,      
				ARV.CD_MC     ,      
				ARV.CD_ARV_MERC_FAMILIA  ,              
				ARV.CD_APRES    ,          
				ARV.CD_ARV_MERC_EQUI  ,      
				ARV.CD_GRP_EXPO    ,      
				P.CD_FABRIC       
			FROM 
				EST_PROD_EST_ARV_MERCADOLOGICA ARV 
				INNER JOIN EST_PROD P ON      
				ARV.CD_EMP  = P.CD_EMP      
				AND ARV.CD_PROD = P.CD_PROD      
			WHERE   
				P.CD_EMP = @CD_EMP;
           
		 -------------------------------------------------------------------------------------------------------------------------------      
		 --CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 1 - PRODUTOS      
		 -------------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 1 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B 
				INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_PROD P ON
				B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON      
				P.CD_EMP = ARV.CD_EMP AND      
				P.CD_PROD = ARV.CD_PROD             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR 
			ORDER BY  B.DT_CAD DESC
		
      
		 -----------------------------------------------------------------------------------------------------------------------------      
		 --CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 2 - FAMÍLIAS      
		 -----------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 2 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B 
				 INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_FAMILIA P ON
				 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON      
				P.CD_EMP = ARV.CD_EMP AND      
				P.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR 
			  ORDER BY 
					B.DT_CAD DESC  
          
		 -----------------------------------------------------------------------------------------------------------------------------          
		 --CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 3 - MARCAS      
		 -----------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 3 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_MC P ON
				 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON      
				P.CD_EMP = ARV.CD_EMP AND      
				P.CD_MC = ARV.CD_MC             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR
			 
			  ORDER BY 
					B.DT_CAD DESC  
      
		 -----------------------------------------------------------------------------------------------------------------------------      
		 --CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 4 - FABRICANTES      
		 -----------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 4 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B 
				 INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_PROD_FABRIC P ON
				 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON         
				P.CD_FABRIC = ARV.CD_FABRIC             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR
				 	
			  ORDER BY 
					B.DT_CAD DESC  

		-----------------------------------------------------------------------------------------------------------------------------      
		--CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 5 - CATEGORIAS      
		 -----------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 5 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_CATEGORIA P ON
				 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON      
				P.CD_EMP = ARV.CD_EMP AND      
				P.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR 
			ORDER BY 
					B.DT_CAD DESC  
		
		 --------------------------------------------------------------------------------------------------------------------------      
		--CONSULTANDO AS TBLS DE GRUPO CURVA VALORES NO NÍVEL 6 - LINHAS      
		 ---------------------------------------------------------------------------------------------------------------------------      
			INSERT INTO #RS_DADOS_TBL_PARAM       
			SELECT
				 P.CD_EMP,
				 P.CD_CTR,
				 ARV.CD_PROD,
				 B.CD_GRUPO_CURVA,
				 B.CD_SIGLA,
				 B.ESEG,
				 B.EMAX,
				 B.P1,
				 B.P2,
				 B.P1_SAZ,
				 B.P2_SAZ,
				 B.FREVISAOMEDIAF,
				 B.PERC_PARETO_ACUMULADO,
				 6 AS TIPO_NIVEL,
				 ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0) AS FLAG_NAO_REVISAR_PARETO_AUTO,
				 B.FREVISAOCURVA
			FROM
				 EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA B 
				 INNER JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_LINHA P ON
				 B.CD_GRUPO_CURVA = P.CD_GRUPO_CURVA 
				INNER JOIN #RS_PROD_ARV_MERC ARV ON      
				P.CD_EMP = ARV.CD_EMP AND      
				P.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA             
			WHERE
				P.CD_EMP=@CD_EMP
				AND P.CD_CTR=@CD_CTR				
			ORDER BY 
				B.DT_CAD DESC  
		/******************************************************************************************************************/

			INSERT INTO  #TMPRESULTGERAL 
			SELECT
					@CD_EMP CD_EMP ,
					@CD_CTR CD_CTR , 
					@CD_FILIAL CD_FILIAL ,
					A.CD_PROD ,
					A.CD_GRUPO_CURVA,
					A.CD_SIGLA,
					CASE 
						WHEN A.CD_SIGLA=5 THEN 'AA'
						WHEN A.CD_SIGLA=1 THEN 'A'
						WHEN A.CD_SIGLA=2 THEN 'B'
						WHEN A.CD_SIGLA=3 THEN 'C'
						WHEN A.CD_SIGLA=4 THEN 'D'
					END DS_SIGLA,

					CASE 
						WHEN A.CD_SIGLA=5 THEN 0
						WHEN A.CD_SIGLA=1 THEN 1
						WHEN A.CD_SIGLA=2 THEN 2
						WHEN A.CD_SIGLA=3 THEN 3
						WHEN A.CD_SIGLA=4 THEN 4
					END ORDEM_SIGLA,
			
					A.ESEG,
					A.EMAX,
					A.P1,
					A.P2,
					A.P1_SAZ,
					A.P2_SAZ,
					A.FREVISAOMEDIAF,
					A.PERC_PARETO_ACUMULADO,
					A.TP_NIVEL,
					A.FLAG_NAO_REVISAR_PARETO_AUTO,
					ISNULL(EST_PARAM_COMPRAS_GRUPO_CURVA_USO.VLR_PARAMETRO,0) VLR_PARAMETRO,
					FREVISAOCURVA 
			FROM 
				#RS_DADOS_TBL_PARAM A  
				LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_USO ON
				A.CD_GRUPO_CURVA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_GRUPO_CURVA AND
				A.CD_CTR =  EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_CTR_COMPRAS_GRUPO AND 
				A.CD_SIGLA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_SIGLA AND
				A.TP_NIVEL = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.TP_NIVEL
			ORDER BY 
				TP_NIVEL ASC
		/****************************************************************************************************************/
		-- PROCESSA O RESULTADO FINAL
		/****************************************************************************************************************/		 
			-- 1 PRODUTOS
			INSERT INTO #TMPRESULT				
			SELECT * 
			FROM 
				#TMPRESULTGERAL
			WHERE 
				TP_NIVEL=1

			-- 2 FAMILIA
			INSERT INTO #TMPRESULT				
			SELECT G.* 
			FROM 
				#TMPRESULTGERAL G
				LEFT JOIN #TMPRESULT R ON 
				G.CD_EMP = R.CD_EMP AND
				G.CD_FILIAL = R.CD_FILIAL AND
				G.CD_PROD = R.CD_PROD
			WHERE 
				G.TP_NIVEL=2
				AND R.CD_EMP IS NULL; 
		
			-- 3 MARCA
			INSERT INTO #TMPRESULT				
			SELECT G.* 
			FROM 
				#TMPRESULTGERAL G
				LEFT JOIN #TMPRESULT R ON 
				G.CD_EMP = R.CD_EMP AND
				G.CD_FILIAL = R.CD_FILIAL AND
				G.CD_PROD = R.CD_PROD
			WHERE 
				G.TP_NIVEL=3
				AND R.CD_EMP IS NULL;

			-- 4 FABRICANTE
			INSERT INTO #TMPRESULT				
			SELECT G.* 
			FROM 
				#TMPRESULTGERAL G
				LEFT JOIN #TMPRESULT R ON 
				G.CD_EMP = R.CD_EMP AND
				G.CD_FILIAL = R.CD_FILIAL AND
				G.CD_PROD = R.CD_PROD
			WHERE 
				G.TP_NIVEL=4
				AND R.CD_EMP IS NULL; 

			-- 5 CATEGORIA
			INSERT INTO #TMPRESULT				
			SELECT G.* 
			FROM 
				#TMPRESULTGERAL G
				LEFT JOIN #TMPRESULT R ON 
				G.CD_EMP = R.CD_EMP AND
				G.CD_FILIAL = R.CD_FILIAL AND
				G.CD_PROD = R.CD_PROD
			WHERE 
				G.TP_NIVEL=5
				AND R.CD_EMP IS NULL;

			-- 6 LINHA
			INSERT INTO #TMPRESULT				
			SELECT G.* 
			FROM 
				#TMPRESULTGERAL G
				LEFT JOIN #TMPRESULT R ON 
				G.CD_EMP = R.CD_EMP AND
				G.CD_FILIAL = R.CD_FILIAL AND
				G.CD_PROD = R.CD_PROD
			WHERE 
				G.TP_NIVEL=6
				AND R.CD_EMP IS NULL;

		INSERT INTO #RS_TAB_PARAMETROS
		SELECT
			   A.CD_EMP
			 , A.CD_CTR
			 , A.CD_PROD
			 , A.CD_GRUPO_CURVA
			 , A.CD_SIGLA
			 , A.DS_SIGLA
			 , A.ORDEM_SIGLA
			 , A.ESEG
			 , A.EMAX
			 , A.P1
			 , A.P2
			 , A.P1_SAZ
			 , A.P2_SAZ
			 , A.FREVISAOMEDIAF
			 , A.PERC_PARETO_ACUMULADO
			 , A.TP_NIVEL
			 , A.FLAG_NAO_REVISAR_PARETO_AUTO
			 , A.VLR_PARAMETRO
			 , A.FREVISAOCURVA
		FROM 
			 EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL F
			 JOIN #TMPRESULT A ON 
			 F.CD_EMP	 = A.CD_EMP AND 
			 F.CD_FILIAL = A.CD_FILIAL 
		WHERE F.CD_EMP = @CD_EMP
			  AND F.CD_FILIAL = @CD_FILIAL;  
	END

	/************************************************************************************************************/

	INSERT INTO #RS_RET
	SELECT
		  CD_EMP
		, CD_CTR
		, CD_PROD
		, MAX(CD_GRUPO_CURVA) CD_GRUPO_CURVA
		, CD_SIGLA
		, DS_SIGLA
		, ORDEM_SIGLA
		, MAX(ESEG) ESEG
		, MAX(EMAX) EMAX
		, MAX(P1) P1
		, MAX(P2) P2
		, MAX(P1_SAZ) P1_SAZ
		, MAX(P2_SAZ) P2_SAZ
		, MAX(FREVISAOMEDIAF) FREVISAOMEDIAF
		, MAX(PERC_PARETO_ACUMULADO) PERC_PARETO_ACUMULADO
		, MAX(TP_NIVEL) TP_NIVEL
		, FLAG_NAO_REVISAR_PARETO_AUTO
		, VLR_PARAMETRO_ATUAL
		, (CASE
			WHEN MAX(CD_GRUPO_CURVA) = 0 THEN 'SEM GRUPO DE CURVAS(%)'
			ELSE 'PARAMETRO DE GRUPO DE CURVAS(%) - TAB: '+CAST(MAX(CD_GRUPO_CURVA) AS VARCHAR)+' NIVEL: '+
				(SELECT DS_NIVEL FROM #TBL_NIVEL N WHERE N.TP_NIVEL = MAX(T.TP_NIVEL))
		END) AS DS_GRUPO_PARAMETRO
		, FREVISAOCURVA
	FROM
		#RS_TAB_PARAMETROS T
	GROUP BY
		 CD_EMP
		, CD_CTR
		, CD_PROD
		, CD_SIGLA
		, DS_SIGLA
		, ORDEM_SIGLA
		, FLAG_NAO_REVISAR_PARETO_AUTO
		, VLR_PARAMETRO_ATUAL
		, FREVISAOCURVA;

	/************************************************************************************************************/
	-- APLICA O MENOR NIVEL
	/************************************************************************************************************/
	
	INSERT INTO #TBL_NIVEL_MENOR
       SELECT
              CD_EMP
            , CD_PROD
            , MIN(TP_NIVEL) NIVELMENOR
       FROM
            #RS_RET
       GROUP BY
                CD_EMP
              , CD_PROD;
	DELETE 
	FROM T 
	FROM 
		#TBL_NIVEL_MENOR	M
		LEFT JOIN #RS_RET T ON 
		M.CD_EMP  = T.CD_EMP AND
		M.CD_PROD = T.CD_PROD
	WHERE  
		T.CD_EMP IS NULL;
	
	
	IF NOT EXISTS (
    SELECT 1
    FROM tempdb.sys.key_constraints kc
    JOIN tempdb.sys.objects o ON kc.parent_object_id = o.object_id
    WHERE kc.[type] = 'PK'
      AND kc.[name] = 'PK_#RS_RET'
      AND o.[name] LIKE '#RS_RET%'
	)
	BEGIN
		ALTER TABLE #RS_RET 
		ADD CONSTRAINT PK_#RS_RET 
		PRIMARY KEY CLUSTERED (CD_EMP ASC, CD_PROD ASC, CD_SIGLA ASC);
	END
	/************************************************************************************************************/
	
	/************************************************************************************************************/
	------------------------------------------------------------------------------------------------------
	UPDATE P
	SET
		  P.VLR_PARAMETRO		= R.VLR_PARAMETRO_ATUAL
		, P.DS_ARV_PARAM		= R.DS_GRUPO_PARAMETRO
		, P.FCURVA				= R.FREVISAOCURVA
		, P.FCURVA_ULT_ATU		= CONVERT(DATE, GETDATE())
		, P.CD_ARV_PARAM		= R.CD_CTR
		, P.CD_GRUPO_CURVA		= R.CD_GRUPO_CURVA
		, P.DT_ULT_ALT			= GETDATE() 
	FROM
		EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P
		JOIN #RS_RET R ON 
		P.CD_EMP =R.CD_EMP AND
		P.CD_PROD =R.CD_PROD AND
		P.CD_SIGLA =R.CD_SIGLA  
	WHERE
		P.CD_EMP=@CD_EMP
		AND P.CD_FILIAL=@CD_FILIAL ;
	
	------------------------------------------------------------------------------------------------------
	INSERT INTO EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD(CD_EMP, CD_FILIAL, CD_PROD
		, CD_SIGLA, VLR_PARAMETRO, DS_ARV_PARAM, FCURVA, FCURVA_ULT_ATU
		, DT_ULT_ALT, CD_ARV_PARAM, CD_GRUPO_CURVA, DT_CAD, CD_ARV_PARAM_MEDIAF)
	SELECT
		L.CD_EMP
		, @CD_FILIAL
		, L.CD_PROD
		, L.CD_SIGLA
		, L.VLR_PARAMETRO_ATUAL
		, L.DS_GRUPO_PARAMETRO
		, L.FREVISAOCURVA
		, CONVERT(DATE, GETDATE()) FCURVA_ULT_ATU
		, GETDATE()  AS DT_ULT_ALT
		, L.CD_CTR
		, L.CD_GRUPO_CURVA AS CD_GRUPO_CURVA
		, GETDATE()
		, L.CD_CTR
	FROM
		#RS_RET L
		LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P ON L.CD_EMP		= P.CD_EMP
																		AND @CD_FILIAL  = P.CD_FILIAL
																		AND L.CD_PROD	= P.CD_PROD 
																		AND L.CD_SIGLA  =  P.CD_SIGLA 
	WHERE
		P.CD_EMP IS NULL;

	------------------------------------------------------------------------------------------------------

	
	